import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc

def calculate_plot_waveform():
    
    num, samp_freq = gc.get_dig_entries(var_num,
                                        var_samp_freq)
    a, f, shape = gc.get_wav_entries(var_a, var_f,
                                     var_shape)

    t = wc.create_time_data(num, samp_freq)
    y = wc.create_waveform_data(t, a, f, shape)

#    win_type = 'hann'
#    win = wc.create_window(win_type, num)
#    y = y*win

    freq_positive, amp_positive = wc.fft_mag_only(y, num,
                                                 samp_freq)

    pc.update_plot(ax, canvas, freq_positive, amp_positive,
                   label_x, label_y, marker='o')
                                        
    return


label_x, label_y = 'Frequency (Hz)', 'Amplitude'

root = gc.create_window(title='FFT (Magnitude Only)',
                        size= '1000x500')
control_box,right_frame = gc.create_frames(root)

var_num, var_samp_freq = gc.digitizing_control(control_box)
var_a, var_f, var_shape = gc.waveform_control(control_box)

ax,canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

gc.action_button(control_box, label='Submit',
                 action=calculate_plot_waveform)

root.mainloop()
